--
--  AppDelegate.applescript
--  iDoneThis
--
--  Created by Jonathan Laliberte on 5/1/12.
--  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
--

property NSUserDefaults : class "NSUserDefaults"

script AppDelegate
	property parent : class "NSObject"
	property fromEmailAddress : ""
    property toEmailAddress : ""
    
    property defaultToAddress : "today@idonethis.com"
    
	on applicationWillFinishLaunching_(aNotification)
		-- Insert code here to initialize your application before any files are opened 
        
        tell standardUserDefaults() of NSUserDefaults
            registerDefaults_({fromEmailAddress:fromEmailAddress, toEmailAddress:toEmailAddress})
            set fromEmailAddress to objectForKey_("fromEmailAddress") as string
            set toEmailAddress to objectForKey_("toEmailAddress") as string
        end tell
	end applicationWillFinishLaunching_
	
	on applicationDidBecomeActive_(sender)
        try
            if toEmailAddress is "" then
                set toEmailAddress to defaultToAddress
            end
            
            set dialogItems to ¬
            (display dialog ¬
            "What'd you do? (sending to: " & toEmailAddress & ")" with title ¬
            "iDoneThis" default answer ¬
            "" buttons {"I Done It!", "Preferences", "Cancel"} ¬
            default button 1)
            
            set buttonName to the button returned of dialogItems
            set donethis to text returned of dialogItems
            
            if buttonName is "Preferences"
            openPrefWindow_(sender)
            else
            if doneThis is not "" then
                tell application "Mail"
                    set MyEmail to make new outgoing message
                    tell MyEmail
                        set content to doneThis
                        set subject to "A new thing I did today"
                        if fromEmailAddress is not ""
                        set sender to fromEmailAddress
                    end if 
                    make new to recipient at end of to recipients with properties {address:toEmailAddress}
                    send
                end tell
            end tell
        end if
    end if
end try
end applicationDidBecomeActive_

on applicationShouldHandleReopen_hasVisibleWindows_(self, visible)
    my applicationDidBecomeActive_(null)
end applicationShouldHandleReopen_hasVisibleWindows

on applicationShouldTerminate_(sender)
    -- Insert code here to do any housekeeping before your application quits 
    tell standardUserDefaults() of NSUserDefaults
        setObject_forKey_(fromEmailAddress, "fromEmailAddress")
        setObject_forKey_(toEmailAddress, "toEmailAddress")
    end tell
    return current application's NSTerminateNow
end applicationShouldTerminate_

on openPrefWindow_(sender)
    set theReturnedItems to (display dialog ¬
    "Change 'From' email address (leave blank to use Mail's default): " with title ¬
    "iDoneThis From Email" default answer ¬
    fromEmailAddress buttons {"Save", "Set Recipient", "Cancel"} ¬
    default button 1)
    
    set theButtonName to the button returned of theReturnedItems
    set theAnswer to the text returned of theReturnedItems
    
    if theButtonName is "Save"
    set fromEmailAddress to theAnswer
    else if theButtonName is "Set Recipient"
    set toEmailItems to (display dialog ¬
    "To email address: (leave blank for default)" with title ¬
    "iDoneThis to Email" default answer toEmailAddress ¬
    buttons {"Save", "Cancel"} default button 1)
    
    set toButtonName to the button returned of toEmailItems
    
    if toButtonName is "Save"
    set toAnswer to the text returned of toEmailItems
    
    if toAnswer is ""
    set toEmailAddress to defaultToAddress
    else
    set toEmailAddress to toAnswer
end
end
end if

applicationDidBecomeActive_(sender)
end openPrefWindow


end script